import numpy as np
import uuid
from envs.constants import *

class Channel:
    def __init__(self, channel_type= HARD, fading=None, rate=None):
        self.uuid = uuid.uuid4()
        self.channel_type = channel_type
        self.bw = []
        self.max_coverage = []
        self.fading = fading
        self.up = rate[0] if rate else 0.02 * GBPS
        self.down = rate[1] if rate else 0.02 * GBPS

    def get_uuid(self):
        return self.uuid.hex

    def get_channel_type(self):
        return self.channel_type

    def get_rate(self, is_up=True):
        if is_up:
            mean_rate = self.up
        else:
            mean_rate = self.down

        if not self.fading:
            return mean_rate
        elif self.fading in 'rR':
            return np.random.rayleigh( np.sqrt(2/np.pi)*mean_rate )
